void sound_set(char reg, char val) __naked{
	/*
		WRTPSG (0093H)		*1
		Function:	writes data in the PSG register
		Input:	A for PSG register number, E for data
		Output:	none
		Registers:	none
	*/
	__asm
  	push	ix  	; prologue
	ld	ix,#0
	add	ix,sp

  	push af	        ; body
	push de
	ld a, 4(ix)
	ld e, 5(ix)
	call 0x0093
	pop de
	pop af

	pop	ix           ;epilogue
	ret
	__endasm;
}

char sound_get(char reg){
	/*
		RDPSG (0096H)		*1
		Function:	reads the PSG register value
		Input:	A for PSG register number
		Output:	A for the value which was read
		Registers:	none
	*/
	__asm
  	push	ix  	; prologue
	ld	ix,#0
	add	ix,sp

	push af         ; body
	ld a, 4(ix)
	call 0x0096
	ld l,a
	pop af
	pop	ix           ;epilogue
	ret
	__endasm;
}


